/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.traceroute;

import ibm.nways.jdm.JdmServer;
import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OID;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.traceroute.RouteTable;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.UnknownHostException;
import java.util.Vector;

public class JdmRouteTable
extends RouteTable {
    protected static final String jdmModelName = "ibm.nways.mib2.model.RouteTable";
    protected String jdmHost = "localhost";
    protected String jdmPort = "2099";
    protected String setCommunityName = "jdm";
    protected JdmServer jdmServer;
    protected GenModel jdmModel;

    public JdmRouteTable(IPAddress iPAddress, String string) throws NotBoundException, MalformedURLException, UnknownHostException, RemoteException {
        super(iPAddress, string);
        this.initialize();
    }

    protected void initialize() throws NotBoundException, MalformedURLException, UnknownHostException, RemoteException {
        String string = "rmi://" + this.jdmHost + ":" + this.jdmPort + "/JdmServer";
        this.jdmServer = (JdmServer)Naming.lookup(string);
        String string2 = "snmp " + this.ipAddress + " " + this.communityName + " " + this.setCommunityName;
        this.jdmModel = (GenModel)this.jdmServer.getModelFor(string2, jdmModelName, null);
        Vector vector = this.jdmModel.getRestOfInfo("Panel", "default", null, null);
        this.routeTable = new Vector();
        int n = 0;
        while (n < vector.size()) {
            this.routeTable.addElement(new JdmRouteTableRow((ModelInfo)vector.elementAt(n)));
            ++n;
        }
    }

    public class JdmRouteTableRow
    extends RouteTable.RouteTableRow {
        private ModelInfo info;

        public JdmRouteTableRow(ModelInfo modelInfo) {
            super(JdmRouteTable.this);
            JdmRouteTable.this = JdmRouteTable.this;
            this.info = modelInfo;
        }

        public IPAddress getIpRouteDest() {
            return (IPAddress)this.info.get("Panel.IpRouteDest");
        }

        public Integer getIpRouteIfIndex() {
            return (Integer)this.info.get("Panel.IpRouteIfIndex");
        }

        public Integer getIpRouteMetric1() {
            return (Integer)this.info.get("Panel.IpRouteMetric1");
        }

        public Integer getIpRouteMetric2() {
            return (Integer)this.info.get("Panel.IpRouteMetric2");
        }

        public Integer getIpRouteMetric3() {
            return (Integer)this.info.get("Panel.IpRouteMetric3");
        }

        public Integer getIpRouteMetric4() {
            return (Integer)this.info.get("Panel.IpRouteMetric4");
        }

        public Integer getIpRouteMetric5() {
            return (Integer)this.info.get("Panel.IpRouteMetric5");
        }

        public IPAddress getIpRouteNextHop() {
            return (IPAddress)this.info.get("Panel.IpRouteNextHop");
        }

        public Integer getIpRouteType() {
            return (Integer)this.info.get("Panel.IpRouteType");
        }

        public Integer getIpRouteProto() {
            return (Integer)this.info.get("Panel.IpRouteProto");
        }

        public Integer getIpRouteAge() {
            return (Integer)this.info.get("Panel.IpRouteAge");
        }

        public IPAddress getIpRouteMask() {
            return (IPAddress)this.info.get("Panel.IpRouteMask");
        }

        public OID getIpRouteInfo() {
            return (OID)this.info.get("Panel.IpRouteInfo");
        }
    }
}

